<?php

namespace YOOtheme;

return [
    'name' => 'text',
    'title' => 'Text',
    'group' => 'basic',
    'icon' => '${url:images/icon.svg}',
    'iconSmall' => '${url:images/iconSmall.svg}',
    'element' => true,
    'width' => 500,
    'defaults' => [
        'margin_top' => 'default',
        'margin_bottom' => 'default',
        'column_breakpoint' => 'm',
    ],
    'placeholder' => [
        'props' => [
            'content' =>
                'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
        ],
    ],
    'updates' => __DIR__ . '/updates.php',
    'templates' => [
        'render' => __DIR__ . '/templates/template.php',
        'content' => __DIR__ . '/templates/content.php',
    ],
    'transforms' => [
        'render' => function ($node) {
            // Don't render element if content fields are empty
            return $node->props['content'] != '';
        },
    ],
    'fields' => [
        'content' => [
            'label' => 'Content',
            'type' => 'editor',
            'source' => true,
        ],
        'dropcap' => [
            'label' => 'Drop Cap',
            'description' => 'Display the first letter of the paragraph as a large initial.',
            'type' => 'checkbox',
            'text' => 'Enable drop cap',
        ],
        'text_style' => [
            'label' => 'Text Style',
            'description' =>
                'Select a predefined text style, including color, size and font-family.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Meta' => 'meta',
                'Lead' => 'lead',
                'Small' => 'small',
                'Large' => 'large',
            ],
        ],
        'text_color' => [
            'label' => 'Text Color',
            'description' =>
                'Select the text color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Muted' => 'muted',
                'Emphasis' => 'emphasis',
                'Primary' => 'primary',
                'Secondary' => 'secondary',
                'Success' => 'success',
                'Warning' => 'warning',
                'Danger' => 'danger',
            ],
        ],
        'column' => [
            'label' => 'Columns',
            'description' => 'Set the number of text columns.',
            'type' => 'select',
            'options' => [
                'None' => '',
                'Halves' => '1-2',
                'Thirds' => '1-3',
                'Quarters' => '1-4',
                'Fifths' => '1-5',
                'Sixths' => '1-6',
            ],
        ],
        'column_divider' => [
            'description' => 'Show a divider between text columns.',
            'type' => 'checkbox',
            'text' => 'Show dividers',
            'enable' => 'column',
        ],
        'column_breakpoint' => [
            'label' => 'Columns Breakpoint',
            'description' => 'Set the device width from which the text columns should apply.',
            'type' => 'select',
            'options' => [
                'Always' => '',
                'Small (Phone Landscape)' => 's',
                'Medium (Tablet Landscape)' => 'm',
                'Large (Desktop)' => 'l',
                'X-Large (Large Screens)' => 'xl',
            ],
            'enable' => 'column',
        ],
        'html_element' => [
            'label' => 'HTML Element',
            'description' =>
                'Define the purpose and structure of the content or give it no semantic meaning.',
            'type' => 'select',
            'options' => [
                'div' => '',
                'address' => 'address',
                'aside' => 'aside',
                'footer' => 'footer',
            ],
        ],
        'position' => '${builder.position}',
        'position_left' => '${builder.position_left}',
        'position_right' => '${builder.position_right}',
        'position_top' => '${builder.position_top}',
        'position_bottom' => '${builder.position_bottom}',
        'position_z_index' => '${builder.position_z_index}',
        'blend' => '${builder.blend}',
        'margin_top' => '${builder.margin_top}',
        'margin_bottom' => '${builder.margin_bottom}',
        'maxwidth' => '${builder.maxwidth}',
        'maxwidth_breakpoint' => '${builder.maxwidth_breakpoint}',
        'block_align' => '${builder.block_align}',
        'block_align_breakpoint' => '${builder.block_align_breakpoint}',
        'block_align_fallback' => '${builder.block_align_fallback}',
        'text_align' => '${builder.text_align_justify}',
        'text_align_breakpoint' => '${builder.text_align_breakpoint}',
        'text_align_fallback' => '${builder.text_align_justify_fallback}',
        'animation' => '${builder.animation}',
        '_parallax_button' => '${builder._parallax_button}',
        'visibility' => '${builder.visibility}',
        'name' => '${builder.name}',
        'status' => '${builder.status}',
        'source' => '${builder.source}',
        'id' => '${builder.id}',
        'class' => '${builder.cls}',
        'attributes' => '${builder.attrs}',
        'css' => [
            'label' => 'CSS',
            'description' =>
                'Enter your own custom CSS. The following selectors will be prefixed automatically for this element: <code>.el-element</code>',
            'type' => 'editor',
            'editor' => 'code',
            'mode' => 'css',
            'attrs' => [
                'debounce' => 500,
                'hints' => ['.el-element'],
            ],
            'source' => true,
        ],
        'transform' => '${builder.transform}',
    ],
    'fieldset' => [
        'default' => [
            'type' => 'tabs',
            'fields' => [
                [
                    'title' => 'Content',
                    'fields' => ['content'],
                ],
                [
                    'title' => 'Settings',
                    'fields' => [
                        [
                            'label' => 'Text',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => [
                                'dropcap',
                                'text_style',
                                'text_color',
                                'column',
                                'column_divider',
                                'column_breakpoint',
                                'html_element',
                            ],
                        ],
                        [
                            'label' => 'General',
                            'type' => 'group',
                            'fields' => [
                                'position',
                                'position_left',
                                'position_right',
                                'position_top',
                                'position_bottom',
                                'position_z_index',
                                'blend',
                                'margin_top',
                                'margin_bottom',
                                'maxwidth',
                                'maxwidth_breakpoint',
                                'block_align',
                                'block_align_breakpoint',
                                'block_align_fallback',
                                'text_align',
                                'text_align_breakpoint',
                                'text_align_fallback',
                                'animation',
                                '_parallax_button',
                                'visibility',
                            ],
                        ],
                    ],
                ],
                '${builder.advanced}',
            ],
        ],
    ],
];
