<?php

// no direct access
defined('_JEXEC') or die;

/** @var Joomla\CMS\Document\HtmlDocument $this */

use Joomla\CMS\Event\Plugin\System\Schemaorg\BeforeCompileHeadEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Event\Event;
use Joomla\Event\Priority;
use YOOtheme\File;
use YOOtheme\Path;

$joomla = Factory::getApplication();
$template = $joomla->getTemplate(true);
$params = $template->params->get('config', []);

if (is_string($params)) {
    $params = json_decode($params, true);
}

$error = $this->error->getCode();
$message = htmlspecialchars($this->error->getMessage(), ENT_QUOTES, 'UTF-8');

if ($error == 404) {
    $joomla->getDispatcher()->dispatch('onLoad404', new Event('onLoad404', [$result = new ArrayObject()]));
}

$this->setMetaData('viewport', 'width=device-width, initial-scale=1');

$this->setTitle($error . ' - ' . $message);

$wa = $this->getWebAssetManager();

$rtl = $this->direction == 'ltr' ? '' : '.rtl';
if (class_exists(File::class)) {
    $url = fn($url) => Path::relative(JPATH_ROOT, $url);
    $style = $url(File::find("~theme/css/theme{.{$template->id},}{$rtl}.css"));
    $wa->registerAndUseStyle('theme', $style, [], !empty($result['customizer']) ? ['id' => 'theme-style'] : [] );
    $wa->registerAndUseStyle('theme-custom-css', $url('~theme/css/custom.css'));

    $wa->registerAndUseScript('uikit', $url('~theme/vendor/assets/uikit/dist/js/uikit.min.js'));
    $wa->registerAndUseScript('uikit-icons', $url('~theme/vendor/assets/uikit/dist/js/uikit-icons.min.js'));
    $wa->registerAndUseScript('theme-custom-js', $url('~theme/js/custom.js'));

    if (!empty($result['customizer'])) {
        $wa
            ->registerAndUseScript('customizer', $url('~assets/site/js/customizer.js'))
            ->registerAndUseStyle('customizer', $url('~assets/site/css/customizer.css'));
    }
} else {
    $wa->registerAndUseStyle('template.system.error', 'media/system/css/system-site-error.css');

    if ($rtl) {
        $wa->registerAndUseStyle('template.system.error_rtl', 'media/system/css/system-site-error_rtl.css');
    }
}

/**
 * Force error context to avoid conflict with Joomla's content plugin.
 * The builder loads Joomla's content plugins.
 *
 * @see \Joomla\Plugin\Content\Joomla\Extension\Joomla::onSchemaBeforeCompileHead
 */
$joomla->getDispatcher()->addListener('onSchemaBeforeCompileHead', function (BeforeCompileHeadEvent $event) {
    $event->setArgument('context', "error.{$event->getContext()}");
}, Priority::HIGH);

?>
<!DOCTYPE html>
<html lang="<?= $this->language ?>" dir="<?= $this->direction ?>">
    <head>
        <jdoc:include type="metas" />
        <?php if (!empty($params['favicon'])) : ?>
        <link rel="icon" href="<?= "{$this->baseurl}/{$params['favicon']}" ?>" sizes="any">
        <?php endif ?>
        <?php if (!empty($params['favicon_svg'])) : ?>
        <link rel="icon" href="<?= "{$this->baseurl}/{$params['favicon_svg']}" ?>" type="image/svg+xml">
        <?php endif ?>
        <?php if (!empty($params['touchicon'])) : ?>
        <link rel="apple-touch-icon" href="<?= "{$this->baseurl}/{$params['touchicon']}" ?>">
        <?php endif ?>
        <jdoc:include type="styles" />
        <jdoc:include type="scripts" />
        <?php if (!empty($result['customizer'])) : ?>
            <?= $result['customizer'] ?>
        <?php endif ?>
        <?php if (!empty($result['head'])) : ?>
            <?= $result['head'] ?>
        <?php endif ?>
    </head>
    <body>

        <div class="tm-page">
            <main id="tm-main">

                <?php if (!empty($result['404'])) : ?>

                <?= $result['404'] ?>

                <?php else : ?>

                <div class="uk-section uk-section-default uk-flex uk-flex-center uk-flex-middle uk-text-center" uk-height-viewport>
                    <div>
                        <h1 class="uk-heading-xlarge"><?= $error ?></h1>
                        <p class="uk-h3"><?= $message ?></p>
                        <a class="uk-button uk-button-primary" href="<?= $this->baseurl ?>/index.php"><?= Text::_('JERROR_LAYOUT_HOME_PAGE') ?></a>

                        <?php if ($this->debug) : ?>
                        <div class="uk-margin-large-top">
                            <?= $this->renderBacktrace() ?>

                            <?php if ($this->error->getPrevious()) : ?>

                                <?php $loop = true ?>

                                <?php $this->setError($this->_error->getPrevious()) ?>

                                <?php while ($loop === true) : ?>
                                    <p><strong><?= Text::_('JERROR_LAYOUT_PREVIOUS_ERROR') ?></strong></p>
                                    <p>
                                        <?= htmlspecialchars($this->_error->getMessage(), ENT_QUOTES, 'UTF-8') ?>
                                        <br/><?= htmlspecialchars($this->_error->getFile(), ENT_QUOTES, 'UTF-8') ?>: <?= $this->_error->getLine() ?>
                                    </p>
                                    <?= $this->renderBacktrace() ?>
                                    <?php $loop = $this->setError($this->_error->getPrevious()) ?>
                                <?php endwhile ?>

                                <?php $this->setError($this->error) ?>

                            <?php endif ?>
                        </div>
                        <?php endif ?>

                    </div>
                </div>

                <?php endif ?>

            </main>
        </div>

    </body>
</html>
