<?php

namespace YOOtheme\Demo\Routes;

use Joomla\CMS\Factory;
use YOOtheme\Config;
use YOOtheme\Builder;
use YOOtheme\Event;
use YOOtheme\Metadata;
use YOOtheme\Http\Request;
use function YOOtheme\app;

/**
 * Injects the UIkit -Full, -Preview or -Trailer layouts into the Joomla document buffer.
 *
 * The layout is selected via the "screenshotStyle" query parameter.
 * Example: themes/balou?screenshotStyle=full
 *
 * The layouts are only updated and cached with the command `npx runner screenshot --set [uikitPreview|uikitPreviewFull|uikitPreviewTrailer]`
 * or using the screenshot functionality in Theme Dev (http://localhost:5173/site/joomla/screenshots)
 *
 */
class ScreenshotStyle
{
    public static function match(Request $request)
    {
        return $request->getQueryParam('screenshotStyle');
    }

    public static function handle($demo, $arg)
    {
        // Check if layout file exists in cache
        if (!file_exists($demo['demoDir'] . "/.cache/screenshot/$arg.json")) {
            return;
        }

        Event::on('theme.head', function () use ($demo) {
            // Add custom CSS when available
            $metadata = app(Metadata::class);
            $metadata->set('style:screenshot-uikit', [
                'href' => "{$demo['dir']}/styles/uikit-preview.css",
            ]);

            // Disable boxed site layout
            $config = app(Config::class);
            $config->set('~theme.site.layout', '');
        });

        $layout = file_get_contents($demo['demoDir'] . "/.cache/screenshot/$arg.json");

        $app = Factory::getApplication();
        $app->getDispatcher()->addListener('onAfterDispatch', function () use ($layout) {
            $builder = app(Builder::class);
            $layout = $builder->render($layout);

            Factory::getApplication()
                ->getDocument()
                ->addStyleDeclaration(
                    '.tm-toolbar, .tm-header, .tm-header-placeholder, .builder[id^="module-"], footer, main ~ * {display: none !important;}',
                )
                ->setBuffer($layout, [
                    'type' => 'component',
                    'name' => null,
                    'title' => null,
                ]);
        });

        // Set theme name in headline
        app()->extend(Builder::class, function ($builder) use ($demo) {
            $builder->addTransform('render', function ($node) use ($demo) {
                if (
                    $node->type === 'headline' &&
                    $node->props['title_element'] === 'h1' &&
                    $node->props['content'] === 'Style Name'
                ) {
                    $node->props['content'] = ucwords(str_replace('-', ' ', $demo['theme']));
                }
            });
        });
    }
}
